      SUBROUTINE DRFFTB(N,R,WSAVE)  
C***BEGIN PROLOGUE  DRFFTB
C***DATE WRITTEN   790601   (YYMMDD)    
C***REVISION DATE  890413   (YYMMDD)    
C***CATEGORY NO.  J1A1   
C***KEYWORDS  FOURIER TRANSFORM    
C***AUTHOR  SWARZTRAUBER, P. N., (NCAR) 
C***PURPOSE  Backward transform of a dp coefficient array.     
C***DESCRIPTION
C     From the book "Numerical Methods and Software"
C          by  D. Kahaner, C. Moler, S. Nash
C               Prentice Hall 1989
C    
C  Subroutine DRFFTB computes the dp perodic sequence from its  
C  Fourier coefficients (Fourier synthesis).  The transform is defined
C  below at output parameter R.    
C    
C  Input Parameters 
C    
C  N       the length of the array R to be transformed.  The method   
C          is most efficient when N is a product of small primes.
C          N may change so long as different work arrays are provided.
C    
C  R       a dp array of length N which contains the sequence  
C          to be transformed  
C    
C  WSAVE   a dp work array which must be dimensioned at least 2*N+15
C          in the program that calls DRFFTB.  The WSAVE array must be  
C          initialized by calling subroutine DRFFTI(N,WSAVE), and a    
C          different WSAVE array must be used for each different 
C          value of N.  This initialization does not have to be  
C          repeated so long as N remains unchanged.  Thus subsequent  
C          transforms can be obtained faster than the first.
C          The same WSAVE array can be used by DRFFTF and DRFFTB.  
C    
C    
C  Output Parameters
C    
C  R       For N even and For I = 1,...,N    
C    
C               R(I) = R(1)+(-1)**(I-1)*R(N) 
C    
C                    plus the sum from K=2 to K=N/2 of 
C    
C                     2.*R(2*K-2)*COS((K-1)*(I-1)*2*PI/N)   
C    
C                    -2.*R(2*K-1)*SIN((K-1)*(I-1)*2*PI/N)   
C    
C          For N odd and For I = 1,...,N
C    
C               R(I) = R(1) plus the sum from K=2 to K=(N+1)/2 of
C    
C                    2.*R(2*K-2)*COS((K-1)*(I-1)*2*PI/N)    
C    
C                   -2.*R(2*K-1)*SIN((K-1)*(I-1)*2*PI/N)    
C    
C   *****  Note:    
C               This transform is unnormalized since a call of DRFFTF  
C               followed by a call of DRFFTB will multiply the input   
C               sequence by N.
C    
C  WSAVE   contains results which must not be destroyed between  
C          calls of DRFFTB or DRFFTF.
C    
C  *                                                                   *   
C  *   1. P.N. Swarztrauber, Vectorizing the FFTs, in Parallel         *   
C  *      Computations (G. Rodrigue, ed.), Academic Press, 1982,       *   
C  *      pp. 51-83.                                                   *   
C  *   2. B.L. Buzbee, The SLATEC Common Math Library, in Sources      *   
C  *      and Development of Mathematical Software (W. Cowell, ed.),   *   
C  *      Prentice-Hall, 1984, pp. 302-318.                            *   
C  *                                                                   *   
C  *********************************************************************   
C    
C***REFERENCES  (NONE)   
C***ROUTINES CALLED  DRFTB1   
C***END PROLOGUE  DRFFTB  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
      DIMENSION       R(*)       ,WSAVE(*)   
C***FIRST EXECUTABLE STATEMENT  DRFFTB   
      IF (N .EQ. 1) RETURN    
      CALL DRFTB1 (N,R,WSAVE,WSAVE(N+1),WSAVE(2*N+1))  
      RETURN   
      END
